package cn.com.duiba.duixintong.center.api.dto.equity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 权益配置
*/
public class EquityDto implements Serializable {

    private static final long serialVersionUID = -4278380630810049297L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 权益类型：1-微信立减金
    */
    private Integer equityType;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
    * 权益名称
    */
    private String equityName;

    /**
     * 发放数量
     */
    private Integer offerNum;

    /**
    * 权益图片
    */
    private String equityImg;

    /**
    * 详细说明
    */
    private String equityDesc;

    /**
    * 是否逻辑删除, 0-未删除, 1-已删除
    */
    private Integer logicDelete;

    /**
     * 扩展字段
     */
    private List<EquityExtDto> extList;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setEquityType(Integer equityType) {
        this.equityType = equityType;
    }

    public Integer getEquityType() {
        return equityType;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    public Long getBankId() {
        return bankId;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setEquityName(String equityName) {
        this.equityName = equityName;
    }

    public String getEquityName() {
        return equityName;
    }

    public Integer getOfferNum() {
        return offerNum;
    }

    public void setOfferNum(Integer offerNum) {
        this.offerNum = offerNum;
    }

    public void setEquityImg(String equityImg) {
        this.equityImg = equityImg;
    }

    public String getEquityImg() {
        return equityImg;
    }

    public void setEquityDesc(String equityDesc) {
        this.equityDesc = equityDesc;
    }

    public String getEquityDesc() {
        return equityDesc;
    }

    public void setLogicDelete(Integer logicDelete) {
        this.logicDelete = logicDelete;
    }

    public Integer getLogicDelete() {
        return logicDelete;
    }

    public List<EquityExtDto> getExtList() {
        return extList;
    }

    public void setExtList(List<EquityExtDto> extList) {
        this.extList = extList;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

