package cn.com.duiba.duixintong.center.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 用户权益发放记录表
*/
@Data
public class UserEquityDto implements Serializable {

    private static final long serialVersionUID = 2215764070234437134L;
    /**
    * id
    */
    private Long id;

    /**
    * 用户id
    */
    private Long userId;

    /**
    * 基于发放的订单编号
    */
    private String orderNum;

    /**
    * 推荐人用户id
    */
    private Long referenceUserId;

    /**
    * 商家ID
    */
    private Long businessId;

    /**
    * 活动ID
    */
    private Long activityId;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
    * 渠道：1-车险，2-银行，3-寿险，4-
    */
    private Integer bankChannel;

    /**
    * 权益ID
    */
    private Long equityId;

    /**
    * 金额
    */
    private Long equityAmount;

    /**
    * 状态 1-创建，2-发放成功，3发放失败，4核销
    */
    private Integer status;

    /**
    * 业务单号
    */
    private String bizNo;

    /**
    * 三方单号
    */
    private String thirdpartOrderNo;

    /**
    * 失败状态码+原因
    */
    private String failReason;

    /**
    * 权益发放渠道
    */
    private Integer channelType;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

