package cn.com.duiba.duixintong.center.api.param.card;

import cn.com.duiba.duixintong.center.api.enums.statistics.DateTypeEnum;
import cn.com.duiba.duixintong.center.api.utils.DateUtils;
import cn.com.duiba.wolf.entity.PageRequest;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/19 17:07
 */
public class CardPageQueryParam extends PageRequest {

    private static final long serialVersionUID = 7384292251717466343L;

    /**
     * 推荐人id
     */
    private Long referenceUserId;

    /**
     * 商家id
     */
    private Long businessId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 卡状态
     */
    private String cardStatus;

    /**
     * 时间维度
     * @see DateTypeEnum
     */
    private DateTypeEnum dateType;

    /**
     * 查询开始时间
     */
    private Long startTime;

    /**
     * 查询截止时间
     */
    private Long endTime;

    public Long getReferenceUserId() {
        return referenceUserId;
    }

    public void setReferenceUserId(Long referenceUserId) {
        this.referenceUserId = referenceUserId;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCardStatus() {
        return cardStatus;
    }

    public void setCardStatus(String cardStatus) {
        this.cardStatus = cardStatus;
    }

    public DateTypeEnum getDateType() {
        return dateType;
    }

    public void setDateType(DateTypeEnum dateType) {
        this.dateType = dateType;
    }

    public Long getStartTime() {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日开始时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayStartTime = cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(new Date());
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongHourStr(dayStartTime);
        }
        // 当月第一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date monthFirstDay = cn.com.duiba.wolf.utils.DateUtils.getMonthDayByIndex(new Date(), 1);
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongDayStr(monthFirstDay);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }

    public Long getEndTime() {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日23:59:59时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayEndTime = cn.com.duiba.wolf.utils.DateUtils.getDayEndTime(new Date());
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongHourStr(dayEndTime);
        }
        // 当月最后一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date endDayOfMonth = DateUtils.getEndDayOfMonth();
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongDayStr(endDayOfMonth);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }
}
