package cn.com.duiba.duixintong.center.api.param.statistics;

import cn.com.duiba.duixintong.center.api.enums.statistics.DateTypeEnum;
import cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatisticsEnum;
import cn.com.duiba.duixintong.center.api.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/19 13:57
 */
public class DimensionStatisticsQueryParam {

    /**
     * 组合id
     */
    private String combinationId;

    /**
     * 维度类型
     * @see DimensionStatisticsEnum
     */
    private DimensionStatisticsEnum dimensionType;

    /**
     * 维度值
     */
    private Integer dimension;

    /**
     * 统计日期类型
     */
    private DateTypeEnum dateType;

    /**
     * 数据查询起始时间
     */
    private Long startTime;

    /**
     * 数据查询结束时间
     */
    private Long endTime;

    public String getCombinationId() {
        return combinationId;
    }

    public void setCombinationId(String combinationId) {
        this.combinationId = combinationId;
    }

    public DimensionStatisticsEnum getDimensionType() {
        return dimensionType;
    }

    public void setDimensionType(DimensionStatisticsEnum dimensionType) {
        this.dimensionType = dimensionType;
    }

    public DateTypeEnum getDateType() {
        return dateType;
    }

    public void setDateType(DateTypeEnum dateType) {
        this.dateType = dateType;
    }

    public Integer getDimension() {
        if (dimensionType == null) {
            return null;
        }
        return dimensionType.getDimension();
    }

    public Long getStartTime() {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日开始时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayStartTime = cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(new Date());
            dateStr = DateUtils.getLongHourStr(dayStartTime);
        }
        // 当月第一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date monthFirstDay = cn.com.duiba.wolf.utils.DateUtils.getMonthDayByIndex(new Date(), 1);
            dateStr = DateUtils.getLongDayStr(monthFirstDay);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }

    public Long getEndTime() {
        if (dateType == null || Objects.equals(dateType, DateTypeEnum.ALL)) {
            return null;
        }
        String dateStr = null;
        // 当日23:59:59时间
        if (Objects.equals(dateType, DateTypeEnum.DAY)) {
            Date dayEndTime = cn.com.duiba.wolf.utils.DateUtils.getDayEndTime(new Date());
            dateStr = DateUtils.getLongHourStr(dayEndTime);
        }
        // 当月最后一天
        if (Objects.equals(dateType, DateTypeEnum.MONTH)) {
            Date endDayOfMonth = DateUtils.getEndDayOfMonth();
            dateStr = cn.com.duiba.duixintong.center.api.utils.DateUtils.getLongDayStr(endDayOfMonth);
        }
        if (StringUtils.isNotBlank(dateStr)) {
            return Long.valueOf(dateStr);
        }
        return null;
    }
}
