package cn.com.duiba.duixintong.center.api.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/23 10:56
 */
public class DateUtils {

    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);

    private static final SimpleDateFormat ONLY_MONTH = getFormat("MM");

    private static final SimpleDateFormat ONLY_DAY = getFormat("dd");

    private static final SimpleDateFormat ONLY_HOUR = getFormat("HH");

    private static final SimpleDateFormat LONG_MONTH = getFormat("yyyyMM");

    private static final SimpleDateFormat LONG_DAY = getFormat("yyyyMMdd");

    private static final SimpleDateFormat LONG_HOUR = getFormat("yyyyMMddHH");


    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    public static String getOnlyHourStr(Date date) {
        synchronized (ONLY_HOUR) {
            return getStr(date, ONLY_HOUR);
        }
    }

    public static String getOnlyDayStr(Date date) {
        synchronized (ONLY_DAY) {
            return getStr(date, ONLY_DAY);
        }
    }

    public static String getOnlyMonthStr(Date date) {
        synchronized (ONLY_MONTH) {
            return getStr(date, ONLY_MONTH);
        }
    }

    public static String getLongHourStr(Date date) {
        synchronized (LONG_HOUR) {
            return getStr(date, LONG_HOUR);
        }
    }

    public static String getLongDayStr(Date date) {
        synchronized (LONG_DAY) {
            return getStr(date, LONG_DAY);
        }
    }

    public static String getLongMonthStr(Date date) {
        synchronized (LONG_MONTH) {
            return getStr(date, LONG_MONTH);
        }
    }

    //获取当前月最后一天：
    public static Date getEndDayOfMonth(){
        Calendar cale = Calendar.getInstance();
        cale.add(Calendar.MONTH, 1);
        cale.set(Calendar.DAY_OF_MONTH, 0);
        cale.set(Calendar.HOUR_OF_DAY,23);
        cale.set(Calendar.MINUTE,59);
        cale.set(Calendar.SECOND,59);
        return cale.getTime();
    }
}
