package cn.com.duiba.duixintong.center.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 公众账号配置表
 * @author kjj mybatis generator 
 * @date 2023-05-08
 */
@Data
public class OfficialAccountDto implements Serializable {

    private static final long serialVersionUID = -4958120144713932961L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 公众账号类型, 1-微信第三方平台, 2-微信公众号/小程序, 3-授权给微信第三方平台的公众号/小程序
     * {@link cn.com.duiba.duixintong.center.api.enums.user.OaTypeEnum}
     */
    private Integer oaType;

    /**
     * 业务类型, 1-兑信通推荐人/访客
     * {@link cn.com.duiba.duixintong.center.api.enums.user.OaBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 排序
     */
    private Integer payLoad;

    /**
     * 公众账号名称
     */
    private String oaName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * 公众账号原始ID
     */
    private String sourceId;

    /**
     * 公众账号加密字符串
     */
    private String appSecret;

    /**
     * 公众账号aes加密字符串
     */
    private String appAesKey;

    /**
     * 微信公众账号消息校验Token
     */
    private String appMsgToken;

    /**
     * 接口调用凭证的刷新凭证
     */
    private String refreshToken;

    /**
     * 所授权的微信第三方平台的oaId
     */
    private Long openPlId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * {@link cn.com.duiba.duixintong.center.api.enums.LogicDeleteEnum}
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}