package cn.com.duiba.duixintong.center.api.enums.statistics;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/19 11:34
 */
public enum DimensionStatisticsEnum {
    /**
     * 商家+推荐人+活动维度 => businessId_referenceId_activityId
     */

    BUSINESS(1, "商家维度"),
    BUSINESS_REFERENCE(2, "商家+推荐人维度"),
    BUSINESS_ACTIVITY(3, "商家+活动维度"),
    REFERENCE_BUSINESS_ACTIVITY(4, "商家+推荐人+活动维度"),
    ;

    private Integer dimension;

    private String desc;

    public static DimensionStatisticsEnum getByDimension(Integer dimension) {
        if (dimension == null) {
            return null;
        }
        DimensionStatisticsEnum[] values = DimensionStatisticsEnum.values();
        for (DimensionStatisticsEnum value : values) {
            if (Objects.equals(value.getDimension(), dimension)) {
                return value;
            }
        }
        return null;
    }

    DimensionStatisticsEnum(Integer dimension, String desc) {
        this.dimension = dimension;
        this.desc = desc;
    }

    public Integer getDimension() {
        return dimension;
    }

    public String getDesc() {
        return desc;
    }
}
