package cn.com.duiba.duixintong.center.api.remoteservice.business;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.business.BusinessDto;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 17:14
 */
@AdvancedFeignClient
public interface RemoteBusinessService {

    /**
     * 根据渠道查询商家列表
     * @param channel
     * @return
     */
    List<BusinessDto> getByChannel(Integer channel);

    /**
     * 根据id查询商家详情
     * @param id
     * @return
     */
    BusinessDto getById(Long id);

    /**
     * 获取推荐人关联商家列表
     * @param referenceId
     * @return
     */
    List<BusinessDto> getBusinessByReferenceId(Long referenceId);

    /**
     * 通过登录账号获取商家信息
     * @param account
     * @return
     */
    BusinessDto getByAccount(String account);
}
