package cn.com.duiba.duixintong.center.api.dto.activity;

import lombok.Data;
import org.stringtemplate.v4.ST;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: pengyi
 * @description: 商家端活动详情
 * @date: 2023/5/20 15:12
 */
@Data
public class BusinessActivityDto implements Serializable {

    private static final long serialVersionUID = -1958529144151656376L;
    /**
     * 活动类型：1-进件, 2-首刷
     */
    private Integer activityType;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 银行mt码
     */
    private String bankMt;

    /**
     * ccp配置
     */
    private String bankCcp;

    /**
     *  banner图片
     */
    private String bannerImg;

    /**
     * 活动介绍
     */
    private String activityDesc;

    /**
     * 是否启用, 0-停用, 1-启用
     */
    private Integer activityStatus;

    /**
     * 商家id
     */
    private Long businessId;

    /**
     * 商家名称
     */
    private String businessName;

    /**
     * 渠道
     */
    private Integer bankChannel;

    /**
     * 关联权益
     */
    private List<String> equityList;
}
