package cn.com.duiba.duixintong.center.api.enums.business;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/22 15:01
 */
public enum BankChannelEnum {
    PROPERTY_INSURANCE(1,"产险"),
    CAR_INSURANCE(2,"车险"),
    LIFE_INSURANCE(3,"寿险"),
    DIRECT_SELLING(4,"直销"),
    ;

    private Integer channel;
    private String bankChannel;

    public static BankChannelEnum getByChannel(Integer channel) {
        if (channel == null) {
            return null;
        }
        BankChannelEnum[] values = BankChannelEnum.values();
        for (BankChannelEnum value : values) {
            if (Objects.equals(value.getChannel(), channel)) {
                return value;
            }
        }
        return null;
    }

    BankChannelEnum(Integer channel, String bankChannel) {
        this.channel = channel;
        this.bankChannel = bankChannel;
    }

    public Integer getChannel() {
        return channel;
    }

    public String getBankChannel() {
        return bankChannel;
    }
}
