package cn.com.duiba.duixintong.center.api.enums.msg;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 * @author dugq
 * @date 2020-02-06
 */
@Getter
@AllArgsConstructor
public enum MessageTypeEnum {
    CUSTOMER_TEXT(1,"text","客服文字消息(公众号和小程序都支持)"),
    CUSTOMER_PIC(2,"image","客服图片消息(公众号和小程序都支持)"),
    CUSTOMER_VOICE(3,"voice","客服音频消息(仅公众号支持)"),
    CUSTOMER_MUSIC(4,"music","客服音乐消息(仅公众号支持)"),
    CUSTOMER_VIDEO(5,"video","客服视频消息(仅公众号支持)"),
    CUSTOMER_CARD(6,"news","客服卡片消息(仅公众号支持)"),
    CUSTOMER_MENU(7,"msgmenu","客服菜单消息(仅公众号支持)"),
    CUSTOMER_MP_CARD(8,"miniprogrampage","客服小程序消息(仅公众号支持)"),
    CUSTOMER_COUPON(9,"wxcard","客服卡券消息(仅公众号支持)"),
    TEMPLATE(10,"template","模版消息(公众号和小程序都支持)"),
    SUBSCRIBE(11,"subscribe","小程序订阅消息(仅小程序支持)"),
    MP_CUSTOMER_LINK(12,"link","小程序客服图文消息(仅小程序支持)"),
    ;
    /**
     * 系统定义code
     */
    private final Integer code;
    /**
     * 对应微信消息的type
     */
    private final String wxType;
    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否客服消息
     */
    public boolean isCustomerMessage(){
        return code<TEMPLATE.getCode();
    }

    /**
     * 是否模版消息
     */
    public boolean isTemplateMessage(){
        return code.equals(TEMPLATE.getCode());
    }

    /**
     * 是否订阅消息
     */
    public boolean isSubscribeMessage(){
        return code.equals(SUBSCRIBE.getCode());
    }

    private static final Map<Integer, MessageTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(MessageTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static MessageTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

}
