package cn.com.duiba.duixintong.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.user.OfficialAccountsDto;

/**
 * 公众账号
 * @author lizhi
 * @date 2023/5/16 11:34 AM
 */
@AdvancedFeignClient
public interface RemoteOfficialAccountsService {

    /**
     * 根据业务类型查询优先级最大的公众账号
     * @param bizType 业务类型
     *                {@link cn.com.duiba.duixintong.center.api.enums.user.OaBizTypeEnum}
     * @return 公众账号配置
     */
    OfficialAccountsDto selectMaxPayLoadByBizType(Integer bizType);
}
