package cn.com.duiba.duixintong.center.api.dto.business;

import cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 商家
 * @author meteor
 */
@Data
public class BusinessDto implements Serializable {

    private static final long serialVersionUID = 1701416345075784028L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 商家编码
    */
    private String businessCode;

    /**
    * 商家logo
    */
    private String businessLogo;

    /**
    * 商家名称
    */
    private String businessName;

    /**
    * 开始时间
    */
    private Date startTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
    * 渠道：1-产险，2-车险，3-寿险，4-直销
     * @see BankChannelEnum
    */
    private Integer bankChannel;

    /**
    * 可营销卡种，以英文逗号分隔
    */
    private String cardCodes;

    /**
    * 员工工号
    */
    private String staffJobNum;

    /**
    * 账号
    */
    private String accountNum;

    /**
     * 商家状态:0-停用，1-启用
     * {@link cn.com.duiba.duixintong.center.api.enums.BooleanEnum}
     */
    private Integer businessStatus;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

