package cn.com.duiba.duixintong.center.api.enums.statistics;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 维度统计，时间类型枚举
 * @author lizhi
 * @date 2023/5/28 9:50 AM
 */
@Getter
@AllArgsConstructor
public enum DimensionStatTimeTypeEnum {
    DAY(1, "天"),
    MONTH(2, "月"),
    ALL(3, "全部"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, DimensionStatTimeTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DimensionStatTimeTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static DimensionStatTimeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
