package cn.com.duiba.duixintong.center.api.param.activity;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:42
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityQueryParam extends PageRequest {

    private static final long serialVersionUID = -3620993614025871784L;
    /**
     * 活动id
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 银行id
     */
    private Long bankId;

    /**
     * 商家id
     */
    private Long businessId;

    /**
     * 活动状态，0-停用，1-启用
     */
    private Integer activityStatus;

    /**
     * 指定活动id
     */
    private List<Long> activityIds;

    /**
     * 当前日期
     */
    private Date now = new Date();
}
