package cn.com.duiba.duixintong.center.api.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 办卡订单通用查询参数
 * @author lizhi
 * @date 2023/5/30 6:19 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BankCardOrderCommonQueryParam extends PageRequest {
    
    private static final long serialVersionUID = 856749952771503236L;

    /**
     * 时间类型
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatTimeTypeEnum}
     */
    private Integer timeType;

    /**
     * 统计维度
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatisticsEnum}
     */
    private Integer statDimension;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 推荐人ID
     */
    private Long referenceUserId;

    /**
     * 办卡状态
     * {@link cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum}
     */
    private Integer cardStatus;
}
