package cn.com.duiba.duixintong.center.api.remoteservice.channel;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信第三方平台服务相关
 * @author lizhi
 * @date 2023/5/19 3:17 PM
 */
@AdvancedFeignClient
public interface RemoteWxOpenPlService {

    /**
     * 拼接授权链接-PC版
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/2.0/api/Before_Develop/Authorization_Process_Technical_Description.html">文档</a><br/>
     * @param openPlId 第三方平台公众账号表主键
     * @param authType 授权类型
     *                 {@link cn.com.duiba.duixintong.center.api.enums.channel.WxOpenPlAuthTypeEnum}
     * @param bizType 授权小程序码业务类型
     *                {@link cn.com.duiba.duixintong.center.api.enums.user.OaBizTypeEnum}
     * @return 链接
     */
    String buildPcPreAuthUrl(Long openPlId, Integer authType, Integer bizType);

    /**
     * 管理员授权后，保存授权公众号/小程序信息
     * @param authCode 回调回来的授权码
     * @param openPlId 第三方平台公众账号表主键
     * @param bizType 授权小程序码业务类型
     *                {@link cn.com.duiba.duixintong.center.api.enums.user.OaBizTypeEnum}
     * @return 是否成功
     */
    boolean saveAuthOa(String authCode, Long openPlId, Integer bizType);

    /**
     * 取消授权
     * @param openPlId 第三方平台公众账号表主键
     * @param oaId 台公众账号表主键
     * @return 是否成功
     */
    boolean unauthorized(Long openPlId, Long oaId);

    /**
     * 第三方服务平台测试用例，微信要求必须有
     * @param authCode 测试用例的授权码
     * @param openId 测试用例给的openId
     * @param openPlId 第三方平台公众账号表主键
     */
    void openPlNotifyTest(String authCode,String openId,Long openPlId);
}
