package cn.com.duiba.duixintong.center.api.dto.card;

import cn.com.duiba.duixintong.center.api.enums.order.BankOrderGrantStautsEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/20 09:59
 */
@Data
public class UserCardOrderDetailDto implements Serializable {

    private static final long serialVersionUID = -7576354178950072263L;

    /**
     * id
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 推荐人用户id
     */
    private Long referenceUserId;

    /**
     * 推荐人
     */
    private String referenceUserName;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 商家
     */
    private String businessName;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 分行中心
     */
    private String bankName;

    /**
     * 渠道：
     */
    private Integer bankChannel;

    /**
     * 订单编号,唯一
     */
    private String orderNum;

    /**
     * 订单最新状态 1-创建，2-进件失败，3-进件成功，4-核批，5-拒批
     * @see cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum
     */
    private String cardStatusText;

    /**
     * 进件时间
     */
    private Date applyTime;

    /**
     * 核批时间
     */
    private Date approvalTime;

    /**
     * 拒批时间
     */
    private Date rejectTime;

    /**
     * 激活时间
     */
    private Date activatedTime;

    /**
     * 首刷时间
     */
    private Date firstUsedTime;

    /**
     * 发放状态  1，拒绝发放  2-发放
     * @see BankOrderGrantStautsEnum
     */
    private Integer grantStatus;

    /**
     * 发放账号
     */
    private String grantAccount;

    /**
     * 原因及明细
     */
    private String grantReason;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 访问时间
     */
    private List<Date> accessTimeList;
}
