package cn.com.duiba.duixintong.center.api.dto.commissioner;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 专员
 * @author kjj mybatis generator 
 * @date 2023-06-28
 */
@Data
public class CommissionerDto implements Serializable {

    private static final long serialVersionUID = -3261603993717091901L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 关联的用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 账号
     */
    private String accountNum;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-银行，2-财产险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum#getChannel()
     */
    private Integer bankChannel;

    /**
     * 工号
     */
    private String jobNum;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}