package cn.com.duiba.duixintong.center.api.dto.important;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 重客
 * @author kjj mybatis generator 
 * @date 2023-06-28
 */
@Data
public class ImportantCustomerDto implements Serializable {

    private static final long serialVersionUID = -4100175495298548960L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 关联的用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 账号
     */
    private String accountNum;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-银行，2-财产险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum#getChannel()
     */
    private Integer bankChannel;

    /**
     * 重客编码
     */
    private String customerCode;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}