package cn.com.duiba.duixintong.center.api.enums.hologres;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chenyongkun
 * @date 2023/6/9
 */
@Getter
@AllArgsConstructor
public enum HologresMetricEnum {
    //订单PV
    ORDER_PV("orderPv", "count(1)", "tb_bank_card_order",  1, "订单PV"),
    ORDER_UN("orderUn", "count(distinct(user_id))-count(distinct(case when ${timeFieldName} < '${startTime}' then user_id end))", "tb_bank_card_order", 2, "订单UV"),
    ORDER_STATUS_PV("orderStatusPv", "count(1)", "tb_bank_card_order_status_record", 1, "订单状态PV"),
    EQUITY_PV("equityPv", "count(1)", "tb_user_equity_status_record", 1, "权益发放PV"),
    REFERENCE_PV("referencePv", "count(1)", "tb_reference_related", 1, "推荐人商家PV"),

    ;

    /**
     * 指标字段名称
     */
    private final String fieldName;

    /**
     * 指标sql代码段
     */
    private final String metricSql;

    /**
     * 指标对应的表名
     */
    private final String tableName;

    /**
     * 类型
     * 1-pv，2-userNum
     * @see HologresMetricTypeEnum
     */
    private final Integer type;

    /**
     * 指标解释说明
     */
    private final String desc;
}
