package cn.com.duiba.duixintong.center.api.param.order;

import lombok.Data;

import java.io.Serializable;

/**
 * 办卡订单通用统计查询参数
 * @author lizhi
 * @date 2023/5/30 6:17 PM
 */
@Data
public class BankCardOrderCommonParam implements Serializable {
    
    private static final long serialVersionUID = 4825019690688696424L;

    /**
     * 时间类型
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatTimeTypeEnum}
     */
    private Integer timeType;

    /**
     * 需要查询哪些数据
     * @see cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatNeedDataTypeEnum
     */
    private Integer needDataType;

    /**
     * 统计维度
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatisticsEnum}
     */
    private Integer statDimension;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 推荐人ID
     */
    private Long referenceUserId;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;
}
