package cn.com.duiba.duixintong.center.api.param.register;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 注册专员
 * @author lizhi
 * @date 2023/6/30 5:55 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class RegisterCommissionerParam extends BaseRegisterParam {
    
    private static final long serialVersionUID = -2847195122652762258L;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-银行，2-财产险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum#getChannel()
     */
    private Integer bankChannel;

    /**
     * 工号
     */
    private String jobNum;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 手机号
     */
    private String userPhone;
}
