package cn.com.duiba.duixintong.center.api.remoteservice.bank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.bank.BankDto;

import java.util.List;

/**
 * @author: pengyi
 * @description: 分行中心
 * @date: 2023/5/17 10:17
 */
@AdvancedFeignClient
public interface RemoteBankService {

    /**
     * 所有分行信息
     * @return
     */
    List<BankDto> allBank();

    /**
     * 分行信息
     * @param bankId
     * @return
     */
    BankDto getById(Long bankId);

    /**
     * 批量查询银行信息
     * @param ids 主键集合
     * @return 分行信息
     */
    List<BankDto> selectByIds(List<Long> ids);
}
