package cn.com.duiba.duixintong.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.order.UserEquityDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserEquityService {

    Long save(UserEquityDto userEquityDto);

    int batchsave(List<UserEquityDto> userEquityDtoList);

    int updateById(UserEquityDto userEquityDto);

    UserEquityDto getById(Long id);

    List<UserEquityDto> listByIds(List<Long> ids);

    UserEquityDto getByOrderNumEquity(String orderNum,Long equityId, String bizNo);

    /**
     * 根据订单号查询订单发放权益
     * @param orderNum 订单号
     * @return 发放权益集合
     */
    List<UserEquityDto> selectByOrderNum(String orderNum);

}
