package cn.com.duiba.duixintong.center.api.enums.hologres;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chenyongkun
 * @date 2023/6/8
 */
@Getter
@AllArgsConstructor
public enum HologresShowTypeEnum {
    ALL(1, "", "", "timeSegment", "直接返回查询时段内的所有数据"),

    DAY(4, "substring(cast(%s as VARCHAR), 0, 11)", "timeSegment", "timeSegment", "根据表分区查询汇总数据"),

    //月
    MONTH(8, "substring(cast(%s as VARCHAR), 0, 8)", "timeSegment", "timeSegment", "根据表查询月汇总数据");

    /**
     * 数据展示格式对应的编码
     */
    private final Integer code;

    /**
     * 需要拼接的sql代码段
     */
    private final String sqlSegment;

    /**
     * 对时间段进行格式转化
     */
    private final String formatSegment;

    /**
     * 时间字段的别名
     */
    private final String fieldName;

    /**
     * 解释说明
     */
    private final String desc;
}
