package cn.com.duiba.duixintong.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.card.BankCardOrderDto;
import cn.com.duiba.duixintong.center.api.dto.card.OrderCommissionSharingResult;
import cn.com.duiba.duixintong.center.api.dto.card.UserCardOrderDetailDto;
import cn.com.duiba.duixintong.center.api.dto.card.UserCardOrderDto;
import cn.com.duiba.duixintong.center.api.param.card.CardOrderParams;
import cn.com.duiba.duixintong.center.api.param.card.CardPageQueryParam;
import cn.com.duiba.duixintong.center.api.param.card.CardUpdateAndSaveParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBankCardOrderService {

    boolean save(BankCardOrderDto bankCardOrderDto);

    boolean updateById(BankCardOrderDto bankCardOrderDto);

    BankCardOrderDto getById(Long id);

    /**
     * 订单号查询订单
     * @param orderNum 订单号
     * @return 订单
     */
    BankCardOrderDto getByOrderNum(String orderNum);

    /**
     * 根据订单号查询分佣结果
     * @param orderNum 订单号
     * @return 分佣结果
     */
    List<OrderCommissionSharingResult> selectCommissionResultByOrderNum(String orderNum);

    List<BankCardOrderDto> listByIds(List<Long> ids);

    List<BankCardOrderDto> queryByParams(CardOrderParams cardOrderParams);

    /**
     * 订单分页查询
     * @param param
     * @return
     */
    PageResponse<UserCardOrderDto> pageByParam(CardPageQueryParam param);

    /**
     * 订单详情
     * @param orderNum
     * @return
     */
    UserCardOrderDetailDto getOrderDetailByOrderNum(String orderNum);

    /**
     * 修改订单状态，并保存流水
     */
    boolean updateAndSaveRecord(CardUpdateAndSaveParam param);

    /**
     * 保存订单，并保存流水
     */
    boolean saveBankCardOrderAndRecord(BankCardOrderDto bankCardOrderDto);


    /**
     * 根据用户id查询用户订单信息
     * @param userId
     * @return
     */
    List<UserCardOrderDetailDto> getOrderDetailByUserId(Long userId, Long referenceUserId, Long businessId, Long activityId);
}
