package cn.com.duiba.duixintong.center.api.remoteservice.fund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 资金账户商家维度统计表 服务类
 * @author lizhi
 * @date 2023/6/8 7:44 PM
 */
@AdvancedFeignClient
public interface RemoteFundAccountBusinessStatService {

    /**
     * 查询累计收益
     * @param accountId 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     * @param accountType 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     * @param businessId 商家ID
     * @return 累计收益
     */
    long selectIncome(Long accountId, Integer accountType, Long businessId);
}
