package cn.com.duiba.duixintong.center.api.dto.equity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 权益配置扩展表
*/
@Data
public class EquityExtDto implements Serializable {

    private static final long serialVersionUID = -8419594352237258612L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 权益ID
    */
    private Long equityId;

    /**
    * 扩展配置key，见枚举
     * @see cn.com.duiba.duixintong.center.api.enums.equity.EquityExtFieldEnum
    */
    private Integer confName;

    /**
     * 扩展配置field
     */
    private String confField;

    /**
    * 扩展配置value
    */
    private String confValue;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

