package cn.com.duiba.duixintong.center.api.dto.withdraw;

import cn.com.duiba.duixintong.center.api.enums.withdraw.WithdrawOrderStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 提现订单表
 * @author kjj mybatis generator 
 * @date 2023-06-19
 */
@Data
public class WithdrawOrderDto implements Serializable {
     
    private static final long serialVersionUID = 16871661138733508L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * @see cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 提现金额(分)
     */
    private Long withdrawAmount;

    /**
     * 提现方式，1-微信零钱，2-公对公转账
     * @see cn.com.duiba.duixintong.center.api.enums.business.BusinessWithdrawTypeEnum
     */
    private Integer withdrawType;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-财险，2-车险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 提现用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 提现人用户微信昵称
     */
    private String nickname;

    /**
     * 提现用户姓名
     */
    private String userName;

    /**
     * 提现用户编辑时验证的手机号
     */
    private String userPhone;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 三方单号
     */
    private String thirdPartOrderNo;

    /**
     * 状态
     * @see WithdrawOrderStatusEnum
     */
    private Integer status;

    /**
     * 失败状态码+原因
     */
    private String failReason;

    /**
     * C端展示的失败原因
     */
    private String showErrMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}