package cn.com.duiba.duixintong.center.api.param.hologres;

import cn.com.duiba.duixintong.center.api.enums.hologres.HologresDimensionEnum;
import cn.com.duiba.duixintong.center.api.enums.hologres.HologresMetricEnum;
import cn.com.duiba.duixintong.center.api.enums.hologres.HologresShowTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author chenyongkun
 * @date 2023/6/8
 */
@Data
public class HologresQueryParam implements Serializable {

    private static final long serialVersionUID = -4744585324615351360L;

    /**
     * 查询的开始时间，时间格式: yyyy-MM-dd HH:mm:ss
     * 不能为空，全部的时候也要给个时间区间
     */
    private String startTime;

    /**
     * 查询的结束时间 时间格式: yyyy-MM-dd HH:mm:ss
     * 不能为空，全部的时候也要给个时间区间
     */
    private String endTime;
    
    /**
     * 本次查询的基础指标列表(至少要有一个), fieldName 不支持重复
     */
    private List<HologresMetricEnum> metricList;

    /**
     * 本次查询的维度列表
     * 可以理解为group by需要的字段（不包含时间）
     */
    private List<HologresDimensionEnum> dimensionList;

    /**
     * 本次查询的时间维度
     */
    private HologresDimensionEnum timeDimensionEnum;

    /**
     * 本次查询的条件 KeyValueDto中key的取值
     * 可以理解为where条件（不包含时间）
     */
    private List<HologresWhereParam> conditionList;

    /**
     * 排序的指标(当前支持单一指标排序) 
     */
    private HologresSortParam orderByMetric;

    /**
     * 数据展示格式, 默认直接返回查询时段内的所有数据
     */
    private HologresShowTypeEnum dataShowType = HologresShowTypeEnum.ALL;
}
