package cn.com.duiba.duixintong.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 活动配置
 * @author meteor
 */
@Data
public class ActivityDetailDto implements Serializable {

    private static final long serialVersionUID = 1543025418874882746L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 活动类型：1-进件, 2-首刷
    */
    private Integer activityType;

    /**
    * 活动名称
    */
    private String activityName;

    /**
    * 开始时间
    */
    private Date startTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
    * 银行scc码
    */
    private String bankScc;

    /**
    * 银行mt码
    */
    private String bankMt;

    /**
     * ccp配置
     */
    private String bankCcp;

    /**
    *  banner图片
    */
    private String bannerImg;

    /**
    * 活动介绍
    */
    private String activityDesc;

    /**
    * 是否启用, 0-停用, 1-启用
    */
    private Integer activityStatus;

    /**
    * 是否逻辑删除, 0-未删除, 1-已删除
    */
    private Integer logicDelete;

    /**
     * 关联权益
     */
    private List<ActivityEquityDto> equityList;

    /**
     * 是否关联商家
     */
    private boolean hasBusiness;

    /**
     * 关联商家id
     */
    private List<ActivityBusinessDto> businessList;

    /**
     * 状态变更次数
     */
    private Integer statusChangeCount;

    /**
     * 渠道
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer channelType;

    /**
     * 分佣规则
     */
    private String commissionSharingRules;

    /**
     * 行内项目id
     */
    private String bankProjectId;

    /**
     * 立项签报号
     */
    private String projectApprovalNumber;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 借记卡参数
     */
    private String cardChannelNo;
}

