package cn.com.duiba.duixintong.center.api.dto.es;

import io.searchbox.annotations.JestId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 活动
 * @author lizhi
 * @date 2023/6/5 7:26 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityEsDto extends BaseEsDto {
    
    private static final long serialVersionUID = -6625723782233384126L;

    /**
     * 主键
     */
    @JestId
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 结束时间
     */
    private Long endTime;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer channelType;

    /**
     * 银行scc码
     */
    private String bankScc;

    /**
     * 银行mt码
     */
    private String bankMt;

    /**
     * ccp配置
     */
    private String bankCcp;

    /**
     * 是否启用, 0-停用, 1-启用
     */
    private Integer activityStatus;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Long gmtCreate;

}
