package cn.com.duiba.duixintong.center.api.dto.operationimport;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 订单操作导入记录
*/
@Data
public class OperationImportRecordDto implements Serializable {

    private static final long serialVersionUID = -1446709422082661655L;

    /**
    * 主键id
    */
    private Long id;

    /**
    * 操作人
    */
    private String operator;

    /**
    * 文件名
    */
    private String fileName;

    /**
    * 处理方式
    */
    private String type;

    /**
    * 状态
    */
    private String status;

    /**
    * 导入总数量
    */
    private Integer totalNum;

    /**
    * 导入成功数量
    */
    private Integer successNum;

    /**
    * 导入失败数量
    */
    private Integer failNum;

    /**
     * 原文件下载地址
     */
    private String uploadUrl;

    /**
    * 失败文件下载地址
    */
    private String excelUrl;

    /**
     * 业务id，具体业务会用到查询
     */
    private String bizId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

