package cn.com.duiba.duixintong.center.api.enums.withdraw;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum WithdrawOrderStatusEnum {

//    DEFAULT(0, "默认"),
    PROCESSING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    RETURN(4, "已返还"),
    VERIFICATION(5, "已核销"),
    ;


    private Integer status;

    private String statusText;

    public static WithdrawOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        WithdrawOrderStatusEnum[] values = WithdrawOrderStatusEnum.values();
        for (WithdrawOrderStatusEnum value : values) {
            if (Objects.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }

}
