package cn.com.duiba.duixintong.center.api.param.card;

import lombok.Data;

import java.io.Serializable;

@Data
public class CardOrderParams implements Serializable {

    private static final long serialVersionUID = 2962470126124334978L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 推荐人id
     */
    private Long referenceUserId;

    /**
     * 商家id
     */
    private Long businessId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 订单最新状态 1-创建，2-进件失败，3-进件成功，4-核批，5-拒批
     * @see cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum
     */
    private Integer cardStatus;

    /**
     * 是否新用户
     */
    private Integer isNewUser;

    /**
     * 分佣类型
     * @see cn.com.duiba.duixintong.center.api.enums.order.OrderCommissionTypeEnum
     */
    private Integer commissionType;

    /**
     * 分佣类型查询类型
     */
    private Long commissionSelectType;

}
