package cn.com.duiba.duixintong.center.api.param.withdraw;

import cn.com.duiba.duixintong.center.api.enums.withdraw.WithdrawOrderStatusEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 提现订单表
 * @author kjj mybatis generator 
 * @date 2023-06-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WithdrawOrderSearchParam extends PageRequest {
     
    private static final long serialVersionUID = 16871661138755041L;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * @see cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 提现方式，1-微信零钱，2-公对公转账
     * @see cn.com.duiba.duixintong.center.api.enums.business.BusinessWithdrawTypeEnum
     */
    private Integer withdrawType;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-财险，2-车险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 提现用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 三方单号
     */
    private String thirdPartOrderNo;

    /**
     * 状态
     * @see WithdrawOrderStatusEnum
     */
    private Integer status;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 权益id
     */
    private Long equityId;
}