package cn.com.duiba.duixintong.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityBusinessDto;

import java.util.List;

/**
 * 活动商家关联表服务
 * @author lizhi
 * @date 2023/6/27 9:45 AM
 */
@AdvancedFeignClient
public interface RemoteActivityBusinessService {

    /**
     * 查询活动关联商家id
     * @param activityId 活动主键
     * @return 关联的商家ID
     */
    List<Long> getBusinessByActivityId(Long activityId);

    /**
     * 查询活动关联商家数量
     * @param activityId 活动ID
     * @return 关联商家数量
     */
    long getActivityBusinessCount(Long activityId);

    /**
     * 批量查询活动关联商家id
     * @param activityIds 活动ID
     * @return 关联商家信息集合
     */
    List<ActivityBusinessDto> getBusinessByActivityIds(List<Long> activityIds);

    /**
     * 查询商家关联活动
     * @param businessId 商家ID
     * @return 根据商家查询关联的活动
     */
    List<Long> getActivityByBusiness(Long businessId);

    /**
     * 查询商家关联活动
     * @param businessIds 商家ID集合
     * @return 根据商家ID集合查询关联的活动
     */
    List<Long> getActivityByBusinessIds(List<Long> businessIds);
}
