package cn.com.duiba.duixintong.center.api.remoteservice.equity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.equity.EquityDto;
import cn.com.duiba.duixintong.center.api.dto.equity.EquityExtDto;
import cn.com.duiba.duixintong.center.api.param.equity.EquityQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:38
 */
@AdvancedFeignClient
public interface RemoteEquityService {

    /**
     * 权益分页查询
     * @param queryParam
     * @return
     */
    PageResponse<EquityDto> pageByParam(EquityQueryParam queryParam);

    /**
     * 新建/编辑 权益
     * @param equityDto
     * @return
     * @throws BizException
     */
    int edit(EquityDto equityDto) throws BizException;

    /**
     * 权益详情-包含扩展信息
     * @param id
     * @return
     */
    EquityDto detailById(Long id);

    /**
     * 权益详情
     * @param id 主键
     * @return 权益
     */
    EquityDto getById(Long id);

    /**
     * 批量查询权益
     * @param ids 主键集合
     * @return 权益详情
     */
    List<EquityDto> getByIds(List<Long> ids);

    /**
     * 根据权益批次号获取权益
     * @param batchNo
     * @return
     */
    EquityExtDto getByBatchNo(String batchNo);

    /**
     * 根据权益id查询批次扩展信息
     * @param equityIds
     * @return
     */
    List<EquityExtDto> getByEquityIds(List<Long> equityIds);
}
