package cn.com.duiba.duixintong.center.api.remoteservice.withdraw;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.withdraw.WithdrawOrderDto;
import cn.com.duiba.duixintong.center.api.param.withdraw.WithdrawOrderSearchParam;

import java.util.List;

/**
 * 提现订单表 服务
 * @author lizhi
 * @date 2023/6/19 5:29 PM
 */
@AdvancedFeignClient
public interface RemoteWithdrawOrderService {

    /**
     * 根据条件分页查询
     * @param param 查询条件
     * @return 提现订单集合
     */
    List<WithdrawOrderDto> selectPage(WithdrawOrderSearchParam param);

    /**
     * 根据业务单号批量查询
     * @param bizNos 业务单号集合
     * @return 提现订单集合
     */
    List<WithdrawOrderDto> selectByBizNos(List<String> bizNos);

    /**
     * 根据业务单号查询
     * @param bizNo 业务单号集合
     * @return 提现订单
     */
    WithdrawOrderDto selectByBizNo(String bizNo);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 提现订单
     */
    WithdrawOrderDto selectById(Long id);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WithdrawOrderSearchParam param);

    /**
     * 将提现记录结果标记
     * @param id 主键
     * @param status 状态
     * @param showErrMsg 拒绝原因(失败时传入)
     * @param thirdPartOrderNo 三方单号(成功时传入)
     * @return 结果
     */
    boolean mark(Long id, Integer status, String showErrMsg, String thirdPartOrderNo);

    /**
     * 将兑换结果标记为过期
     * @param id 主键
     * @param showErrMsg 拒绝原因(失败时传入)
     * @return 结果
     */
    boolean expire(Long id, String showErrMsg);
}
