package cn.com.duiba.duixintong.center.api.dto.activity;

import cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 活动关联商家
 * @author meteor
 */
@Data
public class ActivityBusinessDto implements Serializable {

    private static final long serialVersionUID = -420922064820586107L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 活动ID
    */
    private Long activityId;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
    * 渠道：1-产险，2-车险，3-寿险，4-直销
     * @see BankChannelEnum
    */
    private Integer bankChannel;

    /**
    * 商家ID
    */
    private Long businessId;

    /**
     * 商家名称
     */
    private String businessName;

    /**
    * 是否启用, 0-停用, 1-启用
     * @see cn.com.duiba.duixintong.center.api.enums.BooleanEnum
    */
    private Integer activityStatus;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

