package cn.com.duiba.duixintong.center.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户关联的小程序和公众号
 * @author kjj mybatis generator 
 * @date 2023-05-16
 */
@Data
public class UserExtOaDto implements Serializable {

    private static final long serialVersionUID = 1592434598084781710L;
    
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 公众号是否已关注：0=未关注、1=已关注
     * {@link cn.com.duiba.duixintong.center.api.enums.BooleanEnum}
     */
    private Integer subscribe;

    /**
     * 微信接口返回 access_token，用户解密敏感数据, 小程序为session_key
     */
    private String accessToken;

    /**
     * 微信接口返回 refresh_token
     */
    private String refreshToken;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}