package cn.com.duiba.duixintong.center.api.enums.fund;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 账户业务类型
 * @author lizhi
 * @date 2023/6/6 5:18 PM
 */
@Getter
@AllArgsConstructor
public enum FundAccountBizTypeEnum {
    // 1-提现，2-提现失败回退，3-重客分佣，4-商家分佣，5-推荐人分佣
    WITHDRAW(1, FundAccountChangeTypeEnum.EXPEND, "提现"),
    WITHDRAW_BACK(2, FundAccountChangeTypeEnum.EXPEND_CALLBACK, "提现失败回退"),
    MAJOR_CUSTOMER(3, FundAccountChangeTypeEnum.INCOME, "重客分佣"),
    BUSINESS(4, FundAccountChangeTypeEnum.INCOME, "商家分佣"),
    REFERENCE(5, FundAccountChangeTypeEnum.INCOME, "推荐人分佣"),
    ;
    
    private final Integer type;
    
    private final FundAccountChangeTypeEnum changeTypeEnum;
    
    private final String desc;

    /**
     * 银行办卡单号关联的类型
     */
    public static final Set<Integer> BANK_CARD_ORDER_TYPE_SET = Collections.unmodifiableSet(Stream.of(MAJOR_CUSTOMER.getType(), BUSINESS.getType(), REFERENCE.getType()).collect(Collectors.toSet()));

    /**
     * 展示在收益列表中的业务类型
     */
    public static final List<Integer> SHOW_INCOME_TYPE_LIST = Collections.unmodifiableList(Arrays.asList(MAJOR_CUSTOMER.getType(), BUSINESS.getType(), REFERENCE.getType()));
    
    private static final Map<Integer, FundAccountBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(FundAccountBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static FundAccountBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
