package cn.com.duiba.duixintong.center.api.remoteservice.business;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.business.BusinessDto;
import cn.com.duiba.duixintong.center.api.param.business.BusinessSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 17:14
 */
@AdvancedFeignClient
public interface RemoteBusinessService {

    /**
     * 新增或修改
     * @param dto 商家信息
     * @param password 密码
     * @return 是否成功
     */
    boolean save(BusinessDto dto, String password);

    /**
     * 修改
     * @param dto 商家信息
     * @return 是否成功
     */
    boolean update(BusinessDto dto);

    /**
     * 分页从es查询
     * @param param 分页参数
     * @return left：总条数，right：商家集合
     */
    Pair<Long, List<BusinessDto>> selectPageByEs(BusinessSearchParam param);


    /**
     * 根据条件分页查询
     * @param param 查询条件
     * @return 商家集合
     */
    List<BusinessDto> selectPage(BusinessSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BusinessSearchParam param);

    /**
     * 查询重客下所有商家ID
     * @param importantCustomerId 关联的重客ID
     * @return 商家ID集合
     */
    List<Long> selectIdsByImportant(Long importantCustomerId);

    /**
     * 根据渠道查询商家列表
     * @param channel
     * @return
     */
    List<BusinessDto> getByChannel(List<Integer> channel);

    /**
     * 根据渠道查询商家列表
     * @param channelType
     * @param bankId
     * @return
     */
    List<BusinessDto> getByChannelAndBankId(Integer channelType, Long bankId);

    /**
     * 根据id查询商家详情
     * @param id
     * @return
     */
    BusinessDto getById(Long id);

    /**
     * 获取推荐人关联商家列表
     * @param referenceId
     * @return
     */
    List<BusinessDto> getBusinessByReferenceId(Long referenceId);

    /**
     * 通过登录账号获取商家信息
     * @param account
     * @return
     */
    BusinessDto getByAccount(String account);
}
