package cn.com.duiba.duixintong.center.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.common.LoginAccountDto;

/**
 * 登录账号密码
 * @author lizhi
 * @date 2023/5/17 11:28 AM
 */
@AdvancedFeignClient
public interface RemoteLoginAccountService {

    /**
     * 当密码正确时返回账号信息，否者返回null
     * @param accountNum 账号
     * @param password 输入的密码
     * @return 是否正确
     */
    LoginAccountDto getRightPassWordAccount(String accountNum, String password);

    /**
     * 修改密码
     * @param accountNum 账号
     * @param password 账号密码
     * @return 执行结果
     */
    int updatePassword(String accountNum, String password);

    /**
     * 根据账号查询
     * @param accountNum 账号
     * @return 登录账号信息
     */
    LoginAccountDto selectByAccountNum(String accountNum);
}
