package cn.com.duiba.duixintong.center.api.enums.equity;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:31
 */
public enum EquityExtFieldEnum {
    BATCH_NO(1, "batchNo", "批次号"),
    MAKE_MERCHANT_NO(2, "makeMerchantNo", "制券商户号"),
    OFFER_MERCHANT_NO(3, "offerMerchantNo", "发券商户号"),
    ;

    private Integer code;
    private String field;
    private String desc;

    EquityExtFieldEnum(Integer code, String field, String desc) {
        this.code = code;
        this.field = field;
        this.desc = desc;
    }

    public static EquityExtFieldEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        EquityExtFieldEnum[] values = EquityExtFieldEnum.values();
        for (EquityExtFieldEnum value : values) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }

    public static EquityExtFieldEnum getByField(String field) {
        if (StringUtils.isBlank(field)) {
            return null;
        }
        EquityExtFieldEnum[] values = EquityExtFieldEnum.values();
        for (EquityExtFieldEnum value : values) {
            if (Objects.equals(value.getField(), field)) {
                return value;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getField() {
        return field;
    }

    public String getDesc() {
        return desc;
    }
}
