package cn.com.duiba.duixintong.center.api.enums.fund;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 账户类型
 * @author lizhi
 * @date 2023/6/6 5:18 PM
 */
@Getter
@AllArgsConstructor
public enum FundAccountTypeEnum {
    REFERENCE(1, "推荐人"),
    BUSINESS(2, "商家"),
    IMPORTANT_CUSTOMER(3, "重客"),
    ;
    
    private final Integer type;
    
    private final String desc;

    public static FundAccountTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        FundAccountTypeEnum[] values = FundAccountTypeEnum.values();
        for (FundAccountTypeEnum value : values) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }

}
