package cn.com.duiba.duixintong.center.api.enums.msg;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 * @author dugq
 * @date 2020-02-07
 */
@Getter
@AllArgsConstructor
public enum DegradedTypeEnum {

    DISCARD_NON_LOG(1,"丢弃，无日志"),
    
    DISCARD_INFO_LOG(2,"丢弃，info日志"),
    
    DISCARD_ERROR_LOG(3,"丢弃，打印error日志"),
    ;
    private final Integer code;
    private final String desc;
    
    private static final Map<Integer, DegradedTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DegradedTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static DegradedTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

}
