package cn.com.duiba.geo.console.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.geo.api.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.console.domain.CreateAdministrativeDivisionParams;

import java.util.List;

/**
 * 获取和编辑数据库中的
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteAdministrativeDivisionConsoleService {

    List<AdministrativeDivisionDto> findRegionDivision();

    List<AdministrativeDivisionDto> findAdministrativeDivisionByParentAdCode(String adcode);

    void createAdministrativeDivision(CreateAdministrativeDivisionParams params) throws BizException;

    void deleteAdministrativeDivision(String adcode) throws BizException;

    /**
     * 修改行政区划名称
     */
    void updateAdministrativeDivision(AdministrativeDivisionDto params) throws BizException;

}
