package cn.com.duiba.geo.console.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.geo.api.dto.Point;
import cn.com.duiba.geo.console.domain.PointDto;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteGeoConsoleService {

    /**
     * 拉取行政区划下所有的定位点
     */
    List<PointDto> findPointsByAdCode(String adCode);

    void createPoint(String adCode,Point point) throws BizException;

    void deletePoint(Long pointId) throws BizException;

}
